#! /usr/bin/bash
# echo "oes ALL=(ALL) NOPASSWD: ALL" >> /etc/sudoers.tmp
# Add the user to the root group 
echo "oes ALL=(ALL) NOPASSWD: ALL" | sudo EDITOR='tee -a' visudo                      # add user to sudoers file with NOPASSWD to bypass password prompt 
sudo gpasswd --add oes dialout                                                        # add user to dialout group so user can use the serial port
sudo apt update                                                                       # install appimagelauncher
sudo add-apt-repository -y ppa:appimagelauncher-team/stable                           # ^
sudo apt-get install --yes appimagelauncher                                           # ^
wget https://dl.google.com/linux/direct/google-chrome-stable_current_amd64.deb        # install google chrome
sudo apt install ./google-chrome-stable_current_amd64.deb                             # ^
sudo sh -c 'echo "WaylandEnable=false" >> /etc/gdm3/custom.conf'                      # disable wayland to use x11/xOrg
sudo apt install -y gnome-shell-extensions chrome-gnome-shell                         # install caribou 36 to disable built-in OSK
#sudo apt install curl dbus-x11                                                       # install gnome-shell-extension-installer dependencies
#wget https://raw.githubusercontent.com/brunelli/gnome-shell-extension-installer/master/gnome-shell-extension-installer
#chmod +x gnome-shell-extension-installer                                             # for installing extension installer
#sudo mv gnome-shell-extension-installer /usr/local/bin/                              # make global
#EXTENSION_ID="3222"                                                                  # extension id for block-caribou
#gnome-shell-extension-installer "$EXTENSION_ID" --yes                                # install using id
#EXTENSION_UUID=$(gnome-extensions list | grep -m 1 "$EXTENSION_ID")                  # acquire UUID of extension
#gnome-extensions enable "$EXTENSION_UUID"                                            # enable via UUID
#sudo apt-get install --yes onboard                                                    # install onboard keyboard
#SOURCE_DIR="/home/oes/Ontos"                                                          # move onboard layouts to new directory for config
#DEST_DIR="/home/oes/.local/share/onboard/layouts"				      # ^
#FILES=("test_full_keyboard.onboard" "test_full_keyboard-Alpha.svg" "test_full_keyboard-Numpad.svg") # ^
#mkdir -p "$DEST_DIR"								      # ^						      
#for file in "${FILES[@]}"; do							      # ^
#    sudo cp "$SOURCE_DIR/$file" "$DEST_DIR/"					      # ^
#done										      # ^
sudo groupadd Ontos                                                                   # create group called Ontos
sudo usermod -aG Ontos oes                                                            # add user oes to group for opt subdirectories
sudo mkdir -p -m777 /opt/OTT_PLUS                                                     # create directories and give all permissions
sudo mkdir -p -m777 /opt/OTT_PLUS/NVRAM                                               # ^
sudo mkdir -p -m777 /opt/OTT_PLUS/NVRAM/AUXPCB                                        # ^
sudo mkdir -p -m777 /opt/OTT_PLUS/NVRAM/CTLPCB                                        # ^
sudo mkdir -p -m777 /opt/OTT_PLUS/config                                              # ^
sudo mkdir -p -m777 /opt/OTT_PLUS/logs					              # ^
sudo mkdir -p -m777 /opt/OTT_PLUS/maintenance				              # ^
sudo mkdir -p -m777 /opt/OTT_PLUS/maintenance/ManRecipes		              # ^
echo "0.00,0.00" >> /opt/OTT_PLUS/maintenance/tottimerun.txt                          # ^
sudo apt-get install libsdl2-dev                                                      # xbox controller integration
sudo cp -r "$SOURCE_DIR/Recipes" "/opt/OTT_PLUS"				      # copy recipes folder to OTT_PLUS
sudo cp "$SOURCE_DIR/default.cfg" "/opt/OTT_PLUS/config"			      # copy config file to config directory
sudo chown root:Ontos /opt                                                            # change group ownership of opt
sudo chown root:Ontos /opt/*                                                          # change group ownership of opt subdirectories
sudo chmod 775 /opt                                                                   # give group write permissions for opt
sudo chmod 775 /opt/*                                                                 # give group write permissions
echo "file:///opt/OTT_PLUS" >>  ~/.config/gtk-3.0/bookmarks                           # add OTT_PLUS to bookmarks
APPIMAGE_DIR="/home/oes/Ontos"                                                        # create appimage directory variable
CLEAN_APPIMAGE_FILE=$(ls -t "$APPIMAGE_DIR"/Ontos3-*.AppImage)                        # create clean appimage file variable
CTL_APPIMAGE_FILE=$(ls -t "$APPIMAGE_DIR"/CTL_NVRAM-*.AppImage)                       # create control nvram appimage file variable
OTT_APPIMAGE_FILE=$(ls -t "$APPIMAGE_DIR"/OTT_NVRAM-*.AppImage)                       # create stage nvram appimage file variable
"$CLEAN_APPIMAGE_FILE" --install                                                      # integrate clean appimage
"$CTL_APPIMAGE_FILE" --install                                                        # integrate control nvram appimage file
"$OTT_APPIMAGE_FILE" --install                                                        # integrate stage nvram appimage file
current_favorites=$(gsettings get org.gnome.shell favorite-apps | sed 's/]$//')       # Get the current favorites and strip the closing bracket
new_favorites="'/home/oes/.local/share/applications/*-OTT_NVRAM.desktop', '/home/oes/.local/share/applications/*-Ontos3.desktop', '/home/oes/.local/share/applications/*-CTL_NVRAM.desktop'"                                                                   # Define the three new apps
gsettings set org.gnome.shell favorite-apps "${current_favorites}, ${new_favorites}]" # Set the new favorite apps by appending to the current list

